/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.login;

import com.ibm.hwmca.fw.servlet.login.AutoLogonRequest;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.HMCTimer;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerTaskControl;
import com.ibm.hwmca.fw.util.TimerTaskExecutionControl;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class AutoLogonManager {
    private static final String TRACE_MASKT = "XLGNAUMT";
    private static AutoLogonManager autoLogonManager;
    private AutoLogonInterface autoLogonInterface;
    private List autoLogonRequests;
    private int autoLogonSequence;
    private Random tokenGenerator = new Random();

    public static synchronized AutoLogonManager getAutoLogonManager() {
        if (autoLogonManager == null) {
            autoLogonManager = new AutoLogonManager();
        }
        return autoLogonManager;
    }

    private AutoLogonManager() {
        this.autoLogonInterface = new AutoLogonInterface();
    }

    public synchronized void addAutoLogonRequest(final AutoLogonRequest request) {
        if (this.autoLogonRequests == null) {
            this.autoLogonRequests = new ArrayList(5);
        }
        request.setRecognitionToken(this.createRecognitionToken());
        this.autoLogonRequests.add(request);
        Trace.trace(TRACE_MASKT, "Adding " + request);
        if (request.getTimeout() != 0L) {
            HMCTimer timerManager = HMCTimer.getHMCTimer();
            TimerTaskControl timerTaskControl = timerManager.schedule(new HMCTimerTask(){

                public void run(TimerTaskExecutionControl timerTaskExecutionControl, Object runParms) {
                    AutoLogonManager.this.timeoutRequest(request);
                }
            }, request.getTimeout());
            request.setTimerTaskControl(timerTaskControl);
        }
    }

    private synchronized String createRecognitionToken() {
        StringBuffer token = new StringBuffer();
        token.append(++this.autoLogonSequence);
        token.append(Math.abs(this.tokenGenerator.nextLong()));
        return token.toString();
    }

    public synchronized void removeAutoLogonRequest(AutoLogonRequest request) {
        if (this.autoLogonRequests == null) {
            return;
        }
        if (this.autoLogonRequests.remove(request)) {
            Trace.trace(TRACE_MASKT, "Removing " + request);
            TimerTaskControl timerTaskControl = request.getTimerTaskControl();
            if (timerTaskControl != null) {
                timerTaskControl.cancel();
            }
        }
    }

    private void timeoutRequest(AutoLogonRequest request) {
        Trace.trace(TRACE_MASKT, "Timed out waiting to satisfy " + request);
        request.setTimerTaskControl(null);
        this.removeAutoLogonRequest(request);
        request.fireTimedOut();
    }

    public AutoLogonInterface getAutoLogonInterface() {
        return this.autoLogonInterface;
    }

    public synchronized AutoLogonRequest getRequestForToken(String recognitionToken) {
        if (this.autoLogonRequests == null) {
            return null;
        }
        Iterator iterator = this.autoLogonRequests.iterator();
        while (iterator.hasNext()) {
            AutoLogonRequest autoLogonRequest = (AutoLogonRequest)iterator.next();
            if (!autoLogonRequest.getRecognitionToken().equals(recognitionToken)) continue;
            return autoLogonRequest;
        }
        return null;
    }

    private void associatingWithHMCSession(String recognitionToken, HMCSession hmcSession) {
        AutoLogonRequest autoLogonRequest = this.getRequestForToken(recognitionToken);
        if (autoLogonRequest == null) {
            return;
        }
        TimerTaskControl timerTaskControl = autoLogonRequest.getTimerTaskControl();
        if (timerTaskControl != null) {
            timerTaskControl.cancel();
            autoLogonRequest.setTimerTaskControl(null);
        }
        autoLogonRequest.fireAssociatingWithHMCSession(hmcSession);
    }

    private void disassociatingFromHMCSession(String recognitionToken, HMCSession hmcSession) {
        AutoLogonRequest autoLogonRequest = this.getRequestForToken(recognitionToken);
        if (autoLogonRequest == null) {
            return;
        }
        autoLogonRequest.fireDisassociatingFromHMCSession(hmcSession);
    }

    private void loggedOffOrDisconnected(String recognitionToken, HMCSession hmcSession) {
        AutoLogonRequest autoLogonRequest = this.getRequestForToken(recognitionToken);
        if (autoLogonRequest == null) {
            return;
        }
        autoLogonRequest.fireLoggedOffOrDisconnected(hmcSession);
    }

    public class AutoLogonInterface {
        public void associatingWithHMCSession(String recognitionToken, HMCSession hmcSession) {
            AutoLogonManager.this.associatingWithHMCSession(recognitionToken, hmcSession);
        }

        public void disassociatingFromHMCSession(String recognitionToken, HMCSession hmcSession) {
            AutoLogonManager.this.disassociatingFromHMCSession(recognitionToken, hmcSession);
        }

        public void loggedOffOrDisconnected(String recognitionToken, HMCSession hmcSession) {
            AutoLogonManager.this.loggedOffOrDisconnected(recognitionToken, hmcSession);
        }
    }
}

